/*
 * Decompiled with CFR 0.152.
 */
package ru.smart.timetabledemo.server.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class SpringBootIndexController {
    @Autowired
    private ResourceLoader resourceLoader;

    @RequestMapping(value={"/"})
    public void serveRoot(HttpServletResponse response) throws IOException {
        if (this.resourceLoader.getResource("classpath:/static/index.html").exists()) {
            InputStream is = this.resourceLoader.getResource("classpath:/static/index.html").getInputStream();
            ServletOutputStream os = response.getOutputStream();
            int length = IOUtils.copy((InputStream)is, (OutputStream)os);
            response.setContentType("text/html; charset=UTF-8");
            response.setContentLength(length);
        }
    }

    @RequestMapping(value={"/favicon.ico"})
    public void serveFavicon(HttpServletResponse response) throws IOException {
        if (this.resourceLoader.getResource("classpath:/static/favicon.ico").exists()) {
            InputStream is = this.resourceLoader.getResource("classpath:/static/favicon.ico").getInputStream();
            response.setContentType("image/x-icon");
            ServletOutputStream os = response.getOutputStream();
            int length = IOUtils.copy((InputStream)is, (OutputStream)os);
            response.setContentLength(length);
        }
    }

    private int serveAppForDebug(HttpServletResponse response, HttpServletRequest request) throws IOException {
        String baseFSPath = Paths.get(".", new String[0]).toUri().normalize().getPath();
        String path = request.getRequestURI().replaceFirst("/", "");
        if (path.substring(path.length() - 1).equals("/")) {
            return 0;
        }
        File file = new File(baseFSPath + path);
        if (file.exists()) {
            if (path.contains(".nocache.")) {
                Date now = new Date();
                response.setDateHeader("Date", now.getTime());
                response.setDateHeader("Expires", now.getTime() - 86400000L);
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
            }
            FileInputStream is = new FileInputStream(file);
            ServletOutputStream os = response.getOutputStream();
            int length = IOUtils.copy((InputStream)is, (OutputStream)os);
            return length;
        }
        return 0;
    }

    private int serveAppForBuild(HttpServletResponse response, HttpServletRequest request) throws IOException {
        String path = request.getRequestURI();
        if (!path.substring(path.length() - 1).equals("/") && this.resourceLoader.getResource("classpath:/static" + path).exists()) {
            if (path.contains(".nocache.")) {
                Date now = new Date();
                response.setDateHeader("Date", now.getTime());
                response.setDateHeader("Expires", now.getTime() - 86400000L);
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
            }
            InputStream is = this.resourceLoader.getResource("classpath:/static" + path).getInputStream();
            ServletOutputStream os = response.getOutputStream();
            int length = IOUtils.copy((InputStream)is, (OutputStream)os);
            return length;
        }
        return 0;
    }

    @RequestMapping(value={"/app/*"})
    public void serveApp(HttpServletResponse response, HttpServletRequest request) throws IOException {
        if (request.getRequestURI().endsWith(".js")) {
            response.setContentType("application/javascript; charset=UTF-8");
        } else {
            response.setContentType("text/html; charset=UTF-8");
        }
        int length = this.serveAppForBuild(response, request);
        if (length > 0) {
            response.setContentLength(length);
        }
    }

    @RequestMapping(value={"/css/*"})
    public void serveCss(HttpServletResponse response, HttpServletRequest request) throws IOException {
        String path = request.getRequestURI();
        if (!path.substring(path.length() - 1).equals("/") && this.resourceLoader.getResource("classpath:/static" + path).exists()) {
            InputStream is = this.resourceLoader.getResource("classpath:/static" + path).getInputStream();
            response.setContentType("text/css; charset=UTF-8");
            ServletOutputStream os = response.getOutputStream();
            int length = IOUtils.copy((InputStream)is, (OutputStream)os);
            response.setContentLength(length);
        }
    }

    @RequestMapping(value={"/images/*"})
    public void serveImages(HttpServletResponse response, HttpServletRequest request) throws IOException {
        String path = request.getRequestURI();
        if (!path.substring(path.length() - 1).equals("/") && this.resourceLoader.getResource("classpath:/static" + path).exists()) {
            InputStream is = this.resourceLoader.getResource("classpath:/static" + path).getInputStream();
            response.setContentType("image/png");
            ServletOutputStream os = response.getOutputStream();
            int length = IOUtils.copy((InputStream)is, (OutputStream)os);
            response.setContentLength(length);
        }
    }
}

